/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.core.workflow.engine.model;

import org.silverpeas.core.workflow.api.model.Role;
import org.silverpeas.core.workflow.api.model.Roles;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Class implementing the representation of the &lt;roles&gt; element of a Process Model.
 */
@XmlRootElement(name = "roles")
@XmlAccessorType(XmlAccessType.NONE)
public class RolesImpl implements Serializable, Roles {

  private static final long serialVersionUID = 4241149699620983852L;
  @XmlElement(name = "role", type = RoleImpl.class)
  private List<Role> roleList;

  /**
   * Constructor
   */
  public RolesImpl() {
    roleList = new ArrayList<>();
  }

  /*
   * (non-Javadoc)
   * @see Roles#addRole(com.silverpeas.workflow .api.model.Role)
   */
  @Override
  public void addRole(Role role) {
    roleList.add(role);
  }

  /*
   * (non-Javadoc)
   * @see Roles#createRole()
   */
  @Override
  public Role createRole() {
    return new RoleImpl();
  }

  /*
   * (non-Javadoc)
   * @see Roles#getRole(java.lang.String)
   */
  @Override
  public Role getRole(String name) {
    if (roleList == null) {
      return null;
    }
    for (Role role : roleList) {
      if (name.equals(role.getName())) {
        return role;
      }
    }
    return null;
  }

  /*
   * (non-Javadoc)
   * @see Roles#getRoles()
   */
  @Override
  public Role[] getRoles() {
    if (roleList == null) {
      return new Role[0];
    }
    return roleList.toArray(new Role[0]);
  }

  /*
   * (non-Javadoc)
   * @see Roles#iterateRole()
   */
  @Override
  public Iterator<Role> iterateRole() {
    return roleList.iterator();
  }

  /*
   * (non-Javadoc)
   * @see Roles#removeRole(java.lang.String)
   */
  @Override
  public void removeRole(String strRoleName) {
    if (roleList == null) {
      return;
    }
    roleList.removeIf(r -> r.getName().equals(strRoleName));
  }
}